

;*****************************************************************
;   colortools.pro   (Rivix, LLC. 1998)

;   The procedures here give a simple example of how to
;   create a program with a point-and-click dialog box.

;-----------------------------------
;   List of procedures in this file
;-----------------------------------
;   Choose_Color_event  (event handler for Choose_Color)
;   Choose_Color  (lets you choose a color with RGB sliders)

;   Color_Grid  (displays sections through RGB color cube)

;*****************************************************************
pro Choose_Color_event, event

widget_control, event.top, get_uvalue=state
widget_control, event.id,  get_uvalue=uvalue
if (n_elements(uvalue) eq 0) then uvalue = 'NULL'

INDEX = 0

case (uvalue) of
    'RED'   : begin
              state.Rvalue = event.value
              tvlct, state.Rvalue, state.Gvalue, state.Bvalue, INDEX
              wset,state.WINID  &  tv,state.d
              end
    'GREEN' : begin
              state.Gvalue = event.value
              tvlct,state.Rvalue, state.Gvalue, state.Bvalue, INDEX
              wset,state.WINID  &  tv,state.d
              end
    'BLUE'  : begin
              state.Bvalue = event.value
              tvlct,state.Rvalue, state.Gvalue, state.Bvalue, INDEX
              wset,state.WINID  &  tv,state.d
              end
    'CLOSE' : begin
              ID = event.top
              VALID = widget_info(ID, /VALID_ID)
              if (VALID) then widget_control, ID, /destroy
              end
     ELSE   : dum=0
endcase

if (uvalue ne 'CLOSE') then $
    widget_control, event.top, set_uvalue=state

end;  Choose_Color_event
;*****************************************************************
pro Choose_Color

state = {winID:0L, Rvalue:0, Gvalue:0, Bvalue:255, $
         d:bytarr(150,50)}

;-----------------
;Main base widget
;-----------------
MB = widget_base(TITLE = 'Choose Color Tool',/COLUMN)

;------------
;Draw window
;------------
WD = widget_draw(MB, xsize=150, ysize=50)

;--------------------------
;Red, green & blue sliders
;--------------------------
R = widget_base(MB, /COLUMN)
  R1 = widget_label(R, VALUE='Red Value')
  R2 = widget_slider(R, MAX=255, VALUE=0, UVALUE='RED', XSIZE=150)
G = widget_base(MB, /COLUMN)
  G1 = widget_label(G, VALUE='Green Value')
  G2 = widget_slider(G, MAX=255, VALUE=0, UVALUE='GREEN', XSIZE=150)
B = widget_base(MB, /COLUMN)
  B1 = widget_label(B, VALUE='Blue Value')
  B2 = widget_slider(B, MAX=255, VALUE=255, UVALUE='BLUE', XSIZE=150)

;----------
;OK button
;----------
DB = widget_base(MB, /ROW, /FRAME)
  DB1 = widget_button(DB, VALUE='  OK  ', UVALUE='CLOSE')

;-------------------------------
;Realize widgets, get window ID
;-------------------------------
widget_control, MB, /realize, $
       TLB_SET_XOFFSET=100, TLB_SET_YOFFSET=100

widget_control, WD, get_value=winID
state.winID = winID
tvlct, 0, 0, 255, 0
wset, state.winID
tv, state.d

XOFFSET = 100
YOFFSET = 100
widget_control, MB, set_uvalue=state, /REALIZE, /MAP, $
                XOFFSET=XOFFSET, YOFFSET=YOFFSET, /CLEAR_EVENTS
xmanager, 'Choose_Color', MB, /NO_BLOCK

end;  Choose_Color
;*****************************************************************
pro Color_Grid, RED=RED, GREEN=GREEN, BLUE=BLUE, $
                XSIZE=XSIZE, NB=NB

;--------------------------------------------------------
;NOTES:  This routine creates a "color grid" for viewing
;        different RGB-specified colors.

;        This routine assumes a 16-bit color display.

;        EXAMPLE:  The six exterior faces of the RGB
;        color cube can be displayed with the commands:
;          colorgrid,red=1    &  colorgrid,red=255
;          colorgrid,green=1  &  colorgrid,green=255
;          colorgrid,blue=1   &  colorgrid,blue=255
;--------------------------------------------------------
if NOT(keyword_set(NB)) then NB=16
if NOT(keyword_set(XSIZE)) then XSIZE=256
SIDE = (XSIZE / NB)
tvlct, 0, 0, 0, NB      ;(DEFINE BLACK)

;------------------
;Informative title
;------------------
if (keyword_set(RED)) then begin 
    T='(' + strtrim(string(RED),2) + ', G, B)'
endif else $
if (keyword_set(GREEN)) then begin 
    T='(R, ' + strtrim(string(GREEN),2) + ', B)'
endif else $
if (keyword_set(BLUE)) then begin 
    T='(R, G, ' + strtrim(string(BLUE),2) + ')'
endif else begin
    print,'***********************************'
    print,'SORRY:  No keywords have been set.'
    print,'***********************************'
    RETURN
endelse

;--------------------
;Realize the widgets
;--------------------
MB = widget_base(TITLE='ColorGrid: ' + T)
  WD = widget_draw(MB, xsize=XSIZE+1, ysize=XSIZE+1)
widget_control, MB, /REALIZE
widget_control, WD, GET_VALUE=winID
wset,winID

strip = ((NB * indgen(XSIZE)) / XSIZE) # (intarr(SIDE)+1)
for k=0,(NB-1) do strip[(SIDE*k),*]=NB
strip[*,0] = NB

;----------------------------------------
;Case of fixed red value: green vs. blue
;----------------------------------------
if (keyword_set(RED)) then begin
    R = (intarr(NB) + RED)        ;(fixed red)
    G = ((256/NB) * indgen(NB))
    B = ((256/NB) * indgen(NB))
    for k=0,(NB-1) do begin
        tvlct, R, G, (intarr(NB) + B[k]),0
        tv, strip, 0, (SIDE*k)
    endfor
endif

;----------------------------------------
;Case of fixed green value: red vs. blue 
;----------------------------------------
if (keyword_set(GREEN)) then begin
    R = ((256/NB) * indgen(NB))
    G = (intarr(NB) + GREEN)     ;(fixed green)
    B = ((256/NB) * indgen(NB))
    for k=0,(NB-1) do begin
        tvlct, R, G, (intarr(NB) + B[k]), 0
        tv, strip, 0, (SIDE*k)
    endfor
endif

;----------------------------------------
;Case of fixed blue value: red vs. green
;----------------------------------------
if (keyword_set(BLUE)) then begin
    R = ((256/NB) * indgen(NB))
    G = ((256/NB) * indgen(NB))
    B = (intarr(NB) + BLUE)      ;(fixed blue)
    for k=0,(NB-1) do begin
        tvlct, R, (intarr(NB) + G[k]), B, 0
        tv, strip, 0, (SIDE*k)
    endfor
endif

end;  Color_Grid
;*****************************************************************

